import machine
import uasyncio as asyncio
from ..config import TOUCH_PIN

class TouchSensor:
    def __init__(self, callback=None):
        self._pin = machine.Pin(TOUCH_PIN, machine.Pin.IN, machine.Pin.PULL_UP)
        self._callback = callback

    def on_touch(self, callback_fn):
        """Register a function to call when touched."""
        self._callback = callback_fn

    async def watch(self):
        """Poll for touch events asynchronously (active-low)."""
        while True:
            if self._pin.value() == 0:  # touched
                if self._callback:
                    self._callback()
                # Wait until released to avoid repeat triggering
                while self._pin.value() == 0:
                    await asyncio.sleep_ms(10)
            await asyncio.sleep_ms(20)