import uasyncio as asyncio

class EventScheduler:
    def __init__(self):
        self._loop = asyncio.get_event_loop()

    def call_later(self, delay_s, coro_func):
        """
        Schedule a coroutine to run once after `delay_s` seconds.
        Example:
            scheduler.call_later(2, lambda: my_led.blink())
        """
        async def _delayed():
            await asyncio.sleep(delay_s)
            await coro_func()
        self._loop.create_task(_delayed())

    def call_every(self, interval_s, coro_func):
        """
        Schedule a coroutine to run repeatedly every `interval_s` seconds.
        Example:
            scheduler.call_every(10, lambda: my_servo.expand())
        """
        async def _repeater():
            while True:
                await coro_func()
                await asyncio.sleep(interval_s)
        self._loop.create_task(_repeater())
