"""
Hardware constants and tuning values for Lantern robot.
"""

# ─── SERVO CONFIG ─────────────────────────────
SERVO_PIN       = 21
SERVO_FREQ      = 50
SERVO_MIN_US    = 500
SERVO_MAX_US    = 2400

# ─── VIBRATION / H-BRIDGE CONFIG ──────────────
VIBE_HBRIDGE_A1 = 8  # Motor 1 control pin A
VIBE_HBRIDGE_B1 = 9  # Motor 1 control pin B
DEFAULT_HB_BPM  = 50   # Default beats per minute (90 max recommended)

# ─── AUDIO BUZZER CONFIG ───────────────────────────
BUZZER_PIN = 9

# ─── TOUCH SENSOR CONFIG ─────────────────────────────
TOUCH_PIN = 10

# ─── IMU SENSOR CONFIG ────────────────────────────────
IMU_I2C_ID  = 0
IMU_SCL_PIN = 1
IMU_SDA_PIN = 0

# ─── NEOPIXEL LED CONFIG ──────────────────────────────
LED_PIN   = 21
LED_COUNT = 12
LED_TYPE  = "GRB"
