import uasyncio as aio

async def _oscillate(servo, center, angle_range, frequency, cycles, speed):
    """Helper to oscillate servo around center."""
    step = (1 / frequency) / 2 / speed
    for _ in range(cycles):
        await servo.move(center + angle_range, step)
        await servo.move(center - angle_range, step)
    await servo.move(center, step)

async def wiggle(robot, angle_range=10, frequency=4, speed=1.0):
    """Quick side-to-side wiggle."""
    await _oscillate(robot.servo, 90, angle_range, frequency, 2, speed)

async def sweep(robot, angle_range=45, frequency=0.5, speed=1.0):
    """Slow sweeping motion."""
    await _oscillate(robot.servo, 90, angle_range, frequency, 1, speed)

async def shake(robot, angle_range=5, frequency=8, speed=1.5):
    """Rapid small shake."""
    await _oscillate(robot.servo, 90, angle_range, frequency, 3, speed)
