from dfplayer import DFPlayer
from machine import UART
import time

class DFPlayerAudio:
    def __init__(self, uart_id=0, tx_pin=0, rx_pin=1, volume=20): 
        self._uart = UART(uart_id, tx=tx_pin, rx=rx_pin, baudrate=9600)
        self._df = DFPlayer(uart_id, tx_pin_id=tx_pin, rx_pin_id=rx_pin)
        time.sleep(0.3)  # wait for DFPlayer to initialize
        self._df.volume(volume)

    def play_track(self, folder=1, track=1):
        """Play a track by folder + file index (play(1,1) plays /01/001.mp3)."""
        self._df.play(folder, track)

    def stop(self):
        self._df.stop()

    def set_volume(self, level: int):
        self._df.volume(level)

    def list_files(self, folder=1):
        return self._df.get_files_in_folder(folder)