"""
Neopixel LED ring controller.
"""
from ..config import LED_PIN, LED_COUNT, LED_TYPE

class LEDController:
    def __init__(self, num_pixels=LED_COUNT, pin=LED_PIN, led_type=LED_TYPE):
        from neopixel import Neopixel
        self._pixels = Neopixel(num_pixels, 0, pin, led_type)
        self._num_pixels = num_pixels
        
    def brightness(self, level: int):
        """Set global brightness (0-255)."""
        self._pixels.brightness(level)
    
    def fill(self, color: tuple):
        """Fill all LEDs with a single color (r, g, b)."""
        self._pixels.fill(color)
    
    def set_pixel(self, index: int, color: tuple):
        """Set a single pixel color."""
        if 0 <= index < self._num_pixels:
            self._pixels.set_pixel(index, color)
    
    def show(self):
        """Update the LED display."""
        self._pixels.show()
