import machine
import uasyncio as asyncio
from ..config import BUZZER_PIN

class AudioPlayer:
    def __init__(self):
        self._pin = machine.Pin(BUZZER_PIN)
        self._pwm = None

    def _start_pwm(self, freq: int, duty: int = 32768):
        if self._pwm is None:
            self._pwm = machine.PWM(self._pin)
        self._pwm.freq(freq)
        self._pwm.duty_u16(duty)

    def _stop_pwm(self):
        if self._pwm:
            self._pwm.duty_u16(0)

    async def tone(self, freq: int, duration_ms: int, duty: int = 32768):
        if freq == 0:
            self._stop_pwm()
            await asyncio.sleep_ms(duration_ms)
        else:
            self._start_pwm(freq, duty)
            await asyncio.sleep_ms(duration_ms)
            self._stop_pwm()

    async def play(self, melody, duty: int = 32768):
        """Play a sequence of (freq, ms) tuples."""
        for freq, ms in melody:
            await self.tone(freq, ms, duty)
            await asyncio.sleep_ms(20)  # gap between notes
        self._stop_pwm()