from .actuators.servo import ServoController
from .actuators.vibration import VibrationController
from .actuators.audio import AudioPlayer
from .actuators.music import DFPlayerAudio
from .actuators.led import LEDController
from .sensors.touch import TouchSensor
from .sensors.imu import IMUSensor
from .core.scheduler import EventScheduler

import uasyncio as aio

class Lantern:
    def __init__(self):
        self.servo = ServoController()
        self.vibe = VibrationController()
        self.audio = AudioPlayer()
        self.music = DFPlayerAudio()
        self.led = LEDController()
        self.touch = TouchSensor()
        self.imu = IMUSensor()
        self.sched = EventScheduler()

    def init(self):
        # Basic startup behavior (e.g. go to neutral position, start touch sensor polling)
        # Extend here for core 0 tasks or startup hooks
        self.servo.angle(90)
        aio.create_task(self.touch.watch())
